#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>

int main (int argc, char **argv) {
  char buf[1024];

  // Anzahl Parameter pruefen
  if (argc != 3) {
    sprintf (buf, "%s: Datei kopieren mit %s quelle ziel\n",
             argv[0], argv[0]);
    write (1, buf, strlen(buf));
    exit (1);
  }

  // Quelle zum Lesen oeffnen
  int r_fd = open (argv[1], O_RDONLY);
  if (r_fd < 0) {
    sprintf (buf, "%s: Kann Datei %s nicht zum Lesen oeffnen.\n",
             argv[0], argv[1]);
    write (1, buf, strlen(buf));
    exit (1);
  }

  // Ziel zum Schreiben oeffnen
  int w_fd = open (argv[2], O_WRONLY | O_CREAT | O_TRUNC, 0644);
  if (w_fd < 0) {
    sprintf (buf, "%s: Kann Datei %s nicht zum Schreiben oeffnen.\n",
             argv[0], argv[2]);
    write (1, buf, strlen(buf));
    exit (1);
  }

  // Kopieren
  int bytes = 0; int res;
  for (;;) {
    res = read (r_fd, buf, 1024);     // Hinweis: Fehlerbehandlung zu
    write (w_fd, buf, res);           // read/write fehlt hier...
    bytes = bytes + res;
    if (res < 1024) break;
  }

  // Dateien schliessen
  close (r_fd);
  close (w_fd);

  // Ergebnis
  sprintf (buf, "%s: %d Bytes kopiert.\n",
           argv[0], bytes);
  write (1, buf, strlen(buf));
  exit (0);   // Error Code 0 = alles gut.
}
