[bits 32]

[section .setup]
align 4
mboot:
    MB_HEADER_MAGIC   equ 0x1BADB002
    ; Header flags:
    ;   page align (bit 0), memory info (bit 1)
    MB_HEADER_FLAGS   equ 11b      ; Bits: 1, 0
    MB_CHECKSUM       equ -(MB_HEADER_MAGIC + MB_HEADER_FLAGS)
    EXTERN code, bss, end

    ; This is the GRUB Multiboot header. A boot signature
    dd MB_HEADER_MAGIC   ; 00..03: magic string
    dd MB_HEADER_FLAGS   ; 04..07: flags
    dd MB_CHECKSUM       ; 08..11: checksum

trickgdt:
    dw gdt_end - gdt_data - 1        ; GDT size
    dd gdt_data                      ; linear address of GDT
 
gdt_data:
    ; selector 0x00: empty entry
    dd 0, 0

    ; code selector 0x08:
    ; base 0x40000000, limit 0xFFFFFFFF, type 10011010, flags 1100
    db 0xFF, 0xFF, 0, 0, 0, 10011010b, 11001111b, 0x40      
        
    ; data selector 0x10: 
    ; base 0x40000000, limit 0xFFFFFFFF, type 10010010, flags 1100
    db 0xFF, 0xFF, 0, 0, 0, 10010010b, 11001111b, 0x40      
gdt_end:

global start

start:
    ; BEGIN higher half trick 
    lgdt [trickgdt]
    mov ax, 0x10
    mov ds, ax
    mov es, ax
    mov fs, ax
    mov gs, ax
    mov ss, ax
 
    ; far jump to the higher half kernel
    jmp 0x08:higherhalf


[section .text] 
higherhalf:
    ; END higher half trick 
    mov esp, _sys_stack     ; This points the stack to our new stack area
    push esp                ; save current ESP
    ; push ebx

    extern main             ; C function main() in ulix.c
    call main
    jmp $                   ; infinite loop


global gdt_flush
extern gp
gdt_flush:
    lgdt [gp]
    mov ax, 0x10
    mov ds, ax
    mov es, ax
    mov fs, ax
    mov gs, ax
    mov ss, ax
    jmp 0x08:flush2
flush2:
    ret



global stack_first_address
global stack_last_address


[section .bss]
stack_first_address:
    resb 32*1024               ; This reserves 8KBytes of memory here
stack_last_address:
_sys_stack:



[section .text]

global irq0, irq1, irq2,  irq3,  irq4,  irq5,  irq6,  irq7
global irq8, irq9, irq10, irq11, irq12, irq13, irq14, irq15

%macro irq_macro 1 
       cli                  ; disable interrupts
       push byte 0          ; error code (none)
       push byte %1         ; interrupt number
       jmp irq_common_stub  ; rest is identical for all handlers
%endmacro

irq0:  irq_macro 32
irq1:  irq_macro 33
irq2:  irq_macro 34
irq3:  irq_macro 35
irq4:  irq_macro 36
irq5:  irq_macro 37
irq6:  irq_macro 38
irq7:  irq_macro 39
irq8:  irq_macro 40
irq9:  irq_macro 41
irq10: irq_macro 42
irq11: irq_macro 43
irq12: irq_macro 44
irq13: irq_macro 45
irq14: irq_macro 46
irq15: irq_macro 47

extern irq_handler          ; defined in the C source file

irq_common_stub:            ; this is the identical part
       pusha
       push ds
       push es
       push fs
       push gs
       
       ;mov ax, 0x10
       ;mov ds, ax
       ;mov es, ax
       ;mov fs, ax
       ;mov gs, ax
       
       push esp  ; pointer to the struct regs
       call irq_handler     ; call C function
       pop esp
       pop gs
       pop fs
       pop es
       pop ds
       popa
       add esp, 8
       iret


extern idtp  ; defined in the C file
global idt_load
idt_load:    lidt [idtp]
             ret



global isr0,  isr1,  isr2,  isr3,  isr4,  isr5,  isr6,  isr7,  isr8,  isr9,  isr10
global isr11, isr12, isr13, isr14, isr15, isr16, isr17, isr18, isr19, isr20, isr21
global isr22, isr23, isr24, isr25, isr26, isr27, isr28, isr29, isr30, isr31



%macro isr_macro_0 1 
       cli
       push byte 0
       push byte %1
       jmp isr_common_stub
%endmacro

%macro isr_macro_no0 1 
       cli
       push byte %1
       jmp isr_common_stub
%endmacro


isr0:  isr_macro_0     0   ;  Divide by Zero
isr1:  isr_macro_0     1   ;  Debug
isr2:  isr_macro_0     2   ;  Non Maskable Interrupt
isr3:  isr_macro_0     3   ;  INT 3
isr4:  isr_macro_0     4   ;  INTO
isr5:  isr_macro_0     5   ;  Out of Bounds
isr6:  isr_macro_0     6   ;  Invalid Opcode
isr7:  isr_macro_0     7   ;  Coprocessor not available
isr8:  isr_macro_no0   8   ;  Double Fault
isr9:  isr_macro_0     9   ;  Coprocessor Segment Overrun
isr10: isr_macro_no0  10   ;  Bad TSS
isr11: isr_macro_no0  11   ;  Segment Not Present
isr12: isr_macro_no0  12   ;  Stack Fault
isr13: isr_macro_no0  13   ;  General Protection Fault
isr14: isr_macro_no0  14   ;  Page Fault
isr15: isr_macro_0    15   ;  (reserved)
isr16: isr_macro_0    16   ;  Floating Point
isr17: isr_macro_0    17   ;  Alignment Check
isr18: isr_macro_0    18   ;  Machine Check
isr19: isr_macro_0    19   ;  (reserved)
isr20: isr_macro_0    20   ;  (reserved)
isr21: isr_macro_0    21   ;  (reserved)
isr22: isr_macro_0    22   ;  (reserved)
isr23: isr_macro_0    23   ;  (reserved)
isr24: isr_macro_0    24   ;  (reserved)
isr25: isr_macro_0    25   ;  (reserved)
isr26: isr_macro_0    26   ;  (reserved)
isr27: isr_macro_0    27   ;  (reserved)
isr28: isr_macro_0    28   ;  (reserved)
isr29: isr_macro_0    29   ;  (reserved)
isr30: isr_macro_0    30   ;  (reserved)
isr31: isr_macro_0    31   ;  (reserved)


extern fault_handler

isr_common_stub:
    pusha
    push ds
    push es
    push fs
    push gs
    push esp  ; pointer to the struct regs
    call fault_handler    ; call C function
    pop esp
    pop gs
    pop fs
    pop es
    pop ds
    popa
    add esp, 8            ; for errcode, irq no.

    ;pop eax
    ;or eax, 0x200 ; Set the IF flag.
    ;push eax
    iret
