#define false 0
#define true 1
#define MEM_SIZE 1024*1024*64        // 64 MByte
#define MAX_ADDRESS MEM_SIZE-1       // last valid physical address
#define PAGE_SIZE 4096               // Intel: 4K pages
#define NUMBER_OF_FRAMES MEM_SIZE/PAGE_SIZE
#define asm __asm__
#define volatile __volatile__
#define NULL ((void*) 0)
#define IRQ_TIMER      0
#define IRQ_KBD        1
#define IRQ_SLAVE      2     // Here the slave PIC connects to master
#define IRQ_COM2       3
#define IRQ_COM1       4
#define IRQ_FDC        6
#define IRQ_IDE       14     // primary IDE controller; secondary has IRQ 15
// I/O Addresses of the two programmable interrupt controllers
#define IO_PIC_MASTER_CMD   0x20  // Master (IRQs 0-7), command register
#define IO_PIC_MASTER_DATA  0x21  // Master, control register

#define IO_PIC_SLAVE_CMD    0xA0  // Slave (IRQs 8-15), command register
#define IO_PIC_SLAVE_DATA   0xA1  // Slave, control register
#define END_OF_INTERRUPT  0x20
#define KMAP(pd,frame) \
  fill_page_desc (pd, true, true, false, false, frame)
#define KMAPD(ptd, frame) \
  fill_page_table_desc (ptd, true, true, false, frame)
#define INDEX_FROM_BIT(b) (b/32)   // 32 bits in an unsigned int
#define OFFSET_FROM_BIT(b) (b%32)
#define PHYSICAL(x) ((x)+0xd0000000)
#define PEEK(addr) (*(unsigned char *)(addr))
#define FILL_IDT(i) \
  fill_idt_entry (i, (unsigned int)isr##i, 0x08, 0b1110, 0b1110)


