void *memset (void *dest, char val, int count) {
  char *temp = (char *)dest;
  for( ; count != 0; count--) *temp++ = val;
  return dest;
}

void *memsetw (void *dest, short val, int count) {
  short *temp = (short *)dest;
  for( ; count != 0; count--) *temp++ = val;
  return dest;
}

void kputch (char c) {
  char *screen;
  
  if (c=='\n') {
    posy ++;
    posx = 0;
    uartputc ('\n');
    return;
  }
  
  if (paging_ready)
    screen = (char*) 0xb8000 + posy*160 + posx*2;
  else
    screen = (char*) 0xc0000000 + 0xb8000 + posy*160 + posx*2;
  *screen = c;
  posx++;
  if (posx == 80) {
    posy++; posx = 0;
  }

  // auf serielle Konsole schreiben; ohne Erklärung  
  if (c == 0x100) {  //  backspace
    uartputc('\b'); uartputc(' '); uartputc('\b');
  } else uartputc(c);
}

void clrscr () {
  posx = posy = 0;
  unsigned blank = 0x20 + (0x0f<<8);   // blank character (word)
  char *screen;
  if (paging_ready)
    screen = (char*) 0xb8000;
  else
    screen = (char*) 0xc0000000 + 0xb8000;
  memsetw (screen, blank, 80*25);
}

void *strncpy (void *dest, const void *src, int count) {
  // like memcpy, but copies only until first \0 character
  const char *sp = (const char *)src;
  char *dp = (char *)dest;
  for (; count != 0; count--) {
    *dp = *sp;
    if (*dp == 0) break;
    dp++; sp++;
  }
  return dest;
}

void hexdump (unsigned int start, unsigned int end) {
  char z;
  for (unsigned int i=start; i < end; i+=16) {
    printf ("%x  ", i);  // address
    // hex values
    for (int j=i; j<i+16; j++) {
      printf ("%02x ", (unsigned char)PEEK(j));
      if (j==i+7) kputch (' ');
    };
    kputch (' ');
    // char values
    for (int j=i; j<i+16; j++) {
      z = PEEK(j);
      if ((z>32)&&(z<127)) {
        kputch (PEEK(j));
      } else {
        kputch ('.');
      }
    }
    
    kputch ('\n');
  }
}

unsigned short inportw (unsigned short port) {
  unsigned short retval;
  asm volatile ("inw %%dx, %%ax" : "=a" (retval) : "d" (port));
  return retval;
}

void outportw (unsigned short port, unsigned short data) {
  asm volatile ("outw %%ax, %%dx" : : "d" (port), "a" (data));
}


