extern void gdt_flush();
void gdt_set_gate (int num, unsigned long base, 
  unsigned long limit, unsigned char access, unsigned char gran);
void gdt_install ();
page_table_desc* fill_page_table_desc (page_table_desc *ptd, 
  unsigned int present, unsigned int writeable, 
  unsigned int user_accessible, unsigned int frame_addr);
page_desc* fill_page_desc (page_desc *pd, unsigned int present,
  unsigned int writeable, unsigned int user_accessible,
  unsigned int dirty, unsigned int frame_addr);
static void set_frame (unsigned int frame_addr);
static void clear_frame (unsigned int frame_addr);
static unsigned int test_frame (unsigned int frame_addr);
int request_new_frame ();
void release_frame (unsigned int frameaddr);
unsigned int pageno_to_frameno (unsigned int pageno);
unsigned int* request_new_page (int need_more_pages);
void release_page (unsigned int pageno);
void *memset  (void *dest, char val,  int count);
void *memsetw (void *dest, short val, int count);
extern int printf(const char *format, ...);
void kputch (char c);
extern void uartputc (int c);
void clrscr ();
void *strncpy(void *dest, const void *src, int count);
void hexdump (unsigned int start, unsigned int end);
unsigned char  inportb (unsigned short port);
unsigned short inportw (unsigned short port);
void outportb (unsigned short port, unsigned char data);
void outportw (unsigned short port, unsigned short data);
void fill_idt_entry (unsigned char num, unsigned long address, 
    unsigned short gdtsel, unsigned char flags, unsigned char type);
extern void irq0(), irq1(), irq2(),  irq3(),  irq4(),  irq5(),  irq6(),  irq7();
extern void irq8(), irq9(), irq10(), irq11(), irq12(), irq13(), irq14(), irq15();
static void set_irqmask (unsigned short mask);
static void enable_interrupt (int number);
unsigned short get_irqmask ();
void install_interrupt_handler (int irq, void (*handler)(struct regs *r));
extern void idt_load ();
extern void isr0(),  isr1(),  isr2(),  isr3(),  isr4(),  isr5(),  
   isr6(),  isr7(),  isr8(),  isr9(),  isr10(), isr11(), isr12(), 
   isr13(), isr14(), isr15(), isr16(), isr17(), isr18(), isr19(), 
   isr20(), isr21(), isr22(), isr23(), isr24(), isr25(), isr26(), 
   isr27(), isr28(), isr29(), isr30(), isr31();
void fault_handler (struct regs *r);

