struct gdt_entry {
  unsigned int limit_low   : 16;
  unsigned int base_low    : 16;
  unsigned int base_middle :  8;
  unsigned int access      :  8;
  unsigned int flags       :  4;
  unsigned int limit_high  :  4;
  unsigned int base_high   :  8;
};

struct gdt_ptr {
  unsigned int limit       : 16;
  unsigned int base        : 32;
} __attribute__((packed));

typedef struct {
  unsigned int present         : 1;  //  0
  unsigned int writeable       : 1;  //  1
  unsigned int user_accessible : 1;  //  2
  unsigned int pwt            :  1;  //  3
  unsigned int pcd            :  1;  //  4
  unsigned int accessed       :  1;  //  5
  unsigned int undocumented   :  1;  //  6
  unsigned int zeroes         :  2;  //  8.. 7
  unsigned int unused_bits    :  3;  // 11.. 9
  unsigned int frame_addr     : 20;  // 31..12
} page_table_desc;

typedef struct { page_table_desc ptds[1024]; } page_directory;

typedef struct {
  unsigned int present         : 1;  //  0
  unsigned int writeable       : 1;  //  1
  unsigned int user_accessible : 1;  //  2
  unsigned int pwt            :  1;  //  3
  unsigned int pcd            :  1;  //  4
  unsigned int accessed       :  1;  //  5
  unsigned int dirty          :  1;  //  6
  unsigned int zeroes         :  2;  //  8.. 7
  unsigned int unused_bits    :  3;  // 11.. 9
  unsigned int frame_addr     : 20;  // 31..12
} page_desc;

typedef struct { page_desc pds[1024]; } page_table;

typedef unsigned int boolean;

struct idt_entry {
    unsigned int addr_low  : 16;   // lower 16 bits of address
    unsigned int gdtsel    : 16;   // use which GDT entry?
    unsigned int zeroes    :  8;   // must be set to 0
    unsigned int type      :  4;   // type of descriptor
    unsigned int flags     :  4;
    unsigned int addr_high : 16;   // higher 16 bits of address
} __attribute__((packed));

struct idt_ptr {
    unsigned int limit   : 16;
    unsigned int base    : 32;
} __attribute__((packed));

struct regs {
  unsigned int gs, fs, es, ds;
  unsigned int edi, esi, ebp, esp, ebx, edx, ecx, eax;
  unsigned int int_no, err_code;
  unsigned int eip, cs, eflags, useresp, ss;
};
struct gdt_entry gdt[6];
struct gdt_ptr gp;


